% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{chapter_3_table_7_raw}
\alias{chapter_3_table_7_raw}
\alias{C3T7R}
\alias{Chapter_3_Table_7_Raw}
\alias{c3t7r}
\title{The data used for Chapter 3, Table 7 (raw data to produce the summary measures)}
\format{
An object of class \code{data.frame} with 88 rows and 3 columns.
}
\source{
\url{https://designingexperiments.com/data/}

Maxwell, S. E., Delaney, H. D., & Kelley, K. (2018). \emph{Designing experiments and
analyzing data: {A} model comparison perspective}. (3rd ed.). New York, NY: Routledge.
}
\usage{
data(chapter_3_table_7_raw)
}
\description{
Raw data on the number of drinks per day (and log of the number of drinks)
}
\details{
Average number of standard drinks per week at intake for a sample of homeless alcoholics at nine-month follow-up (Smith, Meyers, & Delaney, 1988). Note that the groups, 1-5, are, respectively, "T1 CRA-D", "T1 CRA+D", "T1Std", "T2 CRA-D", and "T2 Std," where CRA is "Community Reinforcement Approach (with or without Disulfiram) and where "Std" is standard therepy. Note that this is the same data as \code{data(chapter_3_table_9_raw)}.
}
\section{Variables}{

\describe{
\item{Group}{randomly assigned group membership (see details)}
\item{Drinks}{number of standard drinks, on average, per week}
\item{LgDrinks}{log of the number of standard drinks, on average, per week}}
}

\section{Synonym}{

C3T7R
}

\examples{
# Load the data
data(chapter_3_table_7_raw)

# Or, alternatively load the data as
data(C3T7R)

# View the structure
str(chapter_3_table_7_raw)

}
\references{
Maxwell, S. E., Delaney, H. D., & Kelley, K. (2018). \emph{Designing experiments and analyzing data:
{A} model comparison perspective} (3rd ed.). New York, NY: Routledge.

Smith, J. E., Meyers, R. J. & Delaney, H. D. (1998). The community reinforcement approach with homeless alcohol-dependent individuals. \emph{Journal of Consulting and Clinical Psychology, 66}, 541--548.
}
\author{
Ken Kelley \email{kkelley@nd.edu}
}
\keyword{datasets}
