% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{chapter_9_table_7}
\alias{chapter_9_table_7}
\alias{C9T7}
\alias{Chapter_9_Table_7}
\alias{c9t7}
\title{The data used in Chapter 9, Table 7}
\format{
An object of class \code{data.frame} with 30 rows and 3 columns.
}
\source{
\url{https://designingexperiments.com/data/}

Maxwell, S. E., Delaney, H. D., & Kelley, K. (2018). \emph{Designing experiments and
analyzing data: {A} model comparison perspective}. (3rd ed.). New York, NY: Routledge.
}
\usage{
data(chapter_9_table_7)
}
\description{
The data used in Chapter 9, Table 7
}
\details{
The data shown in Table 9.7 represents a hypothetical three-group study assessing different interventions for depression. 30 depressive individuals have been randomly assigned to one of three conditions: (1) selective serotonin reuptake inhibitor (SSRI) antidepressant medication, (2) placebo, or (3) wait list control. The Beck Depression Inventory (BDI) has been administered to each individual prior to the study, and then later is administered a second time at the end of the study. The data represents a three group pre-post design, where the 30 depressives were randomly assigned to one of three conditions. The primary question of interest is: "do individuals in some groups change more on their measures of depression than do individuals in other groups?"#'
}
\section{Variables}{

\describe{
\item{cond}{the treatment condition (SSRI, Placebo, Wait List Control)}
\item{pre}{the measure of depression before the experiment}
\item{post}{the measure of depression after the experiment}
}
}

\section{Synonym}{

C9T7
}

\examples{
# Load the data
data(chapter_9_table_7)

# Or, alternatively load the data as
data(C9T7)

# View the structure
str(chapter_9_table_7)

}
\references{
Maxwell, S. E., Delaney, H. D., & Kelley, K. (2018). \emph{Designing experiments and analyzing data:
{A} model comparison perspective} (3rd ed.). New York, NY: Routledge.
}
\author{
Ken Kelley \email{kkelley@nd.edu}
}
\keyword{datasets}
