datacheck <-
function (dataICHS,dataTSSS,conflevel=0.95,pchdata=19,coldata='green',cexdata=0.5,pchsample=19,colsample='red',cexsample=3,xaxis=xaxis, yaxis=yaxis ,title=title,linetyprediction=2,linewidthprediction=1,linecolorprediction=5) {


par(mfrow=c(1,2))
nrowdata<-nrow(dataICHS)
ncoldata<- ncol(dataICHS)
xaxis='CONDUCTIVITY'
yaxis='IONIC CHARGE SUMMATION'
title='ICHS plot'
for(i in 1:nrowdata){
  dataICHS[i,(ncoldata+1)]<-sum(dataICHS[i,c(2:ncoldata)],na.rm=TRUE)
  }
datas<-subset(dataICHS,dataICHS[,2]!='NA' & dataICHS[,ncoldata+1]!='NA')
lmchargesummation<-lm(datas[,ncoldata+1]~datas[,2]-1) 
predictchargesummation<-as.data.frame(predict(lmchargesummation,datas,interval = "prediction",level=conflevel)) 
plot(datas[,2],datas[,(ncoldata+1)],pch=pchdata,col=coldata,cex=cexdata,xlab=xaxis, ylab=yaxis,main=title) 
lines(spline(datas[,2],predictchargesummation[,3]),lty=linetyprediction,col=linecolorprediction,lwd=linewidthprediction) 
lines(spline(datas[,2],predictchargesummation[,2]),lty=linetyprediction,col=linecolorprediction,lwd=linewidthprediction) 
ICHSoutliers<-c()
for(i in 1:nrow(datas)){
if(datas[i,(ncol(datas))]>predictchargesummation[i,3]|datas[i,(ncol(datas))]<predictchargesummation[i,2]){
points(datas[i,2],datas[i,(ncol(datas))],pch=pchsample,col=colsample,cex=cexsample) 
ICHSoutliers<-c(ICHSoutliers,datas[i,1])
}
}

nrowdata<-nrow(dataTSSS)
ncoldata<- ncol(dataTSSS)
xaxis='TOTAL SOLUBLE SOLIDS'
yaxis='MASS SUMMATION'
title='TSSS plot'
for(i in 1:nrowdata){
dataTSSS[i,(ncoldata+1)]<-sum(dataTSSS[i,c(3:ncoldata)],na.rm=TRUE)
}
datas<-subset(dataTSSS,dataTSSS[,2]!='NA' & dataTSSS[,ncoldata+1]!='NA') 
lmsumatoriamasas<-lm(datas[,ncoldata+1]~datas[,2]-1) 
predictsumatoriamasas<-as.data.frame(predict(lmsumatoriamasas,datas,interval = "prediction",level=conflevel)) 
plot(datas[,2],datas[,ncol(datas)],pch=pchdata,col=coldata,cex=cexdata,xlab=xaxis, ylab=yaxis,main=title) 
lines(spline(datas[,2],predictsumatoriamasas[,3]),lty=linetyprediction,col=linecolorprediction,lwd=linewidthprediction) 
lines(spline(datas[,2],predictsumatoriamasas[,2]),lty=linetyprediction,col=linecolorprediction,lwd=linewidthprediction) 
TSSSoutliers<-c()
for(i in 1:nrow(datas)){
if(datas[i,(ncol(datas))]>predictsumatoriamasas[i,3]|datas[i,(ncol(datas))]<predictsumatoriamasas[i,2]){
points(datas[i,2],datas[i,(ncol(datas))],pch=pchsample,col=colsample,cex=cexsample) 
TSSSoutliers<-c(TSSSoutliers,datas[i,1])
}
}

outliers<-c()

for(i in 1:length(ICHSoutliers)){
	for(j in 1:length(TSSSoutliers)){
	if(TSSSoutliers[j]==ICHSoutliers[i]){
			outliers=c(outliers,ICHSoutliers[i])
	}

}
}

print('data excluded by ICHS and TSSS criteria')
print(outliers)

par(mfrow=c(1,1))

}
