\name{validation}
\alias{validation}
\title{
Quality parameters of a measurement technique
}
\description{
Calculate the quality parameters of a technique for the measurement of a chemical component. 
}

\usage{
validation(datavalidation, numest = NULL, measurementunit = NULL, 
techniquename = NULL,  date = Sys.Date(), graph = FALSE)
}


\arguments{
  \item{datavalidation}{
Data.frame with data for points of a calibration curve of five points, including a reagent blank and four standards. The data.frame also includes a solution of known concentration called quality control (qc). The columns include name of the tube, concentration, absorbance and day of measurement.  
}
  \item{numest}{
The number of standards solution used for the calibration curve. This number do not include the reagen t blank.
}
  \item{measurementunit}{
The unit of measurement of the concentration.
}
  \item{techniquename}{
The name of the technique whose quality parameters are calculated.
}
  \item{date}{
The date when the procedure is performed.
}
  \item{graph}{
Graph argument allows to plot the calibration curve.
}
}


\details{
The validation() function calculates a set of quality parameters of a technique for the measurement of a chemical component. The function needs the values of a property (absorbance in the example) of standard solutions with different known concentration of one chemical component of water, measured in three different days. The function also needs the values of the property of a solution with a known concentration of the component, different from the standards of the calibration curve, which is called quality control solution (qc).
}


\value{
The datavalidation() function returns a graph of the calibration curve if the argument graph takes the value TRUE. The function calculates and returns a list with the values of the slope of the calibration curve, the detection limit (LOD), the quantification limit (LOQ), correlation coefficient, sensitivity, accuracy, intraassay repetitivity, interassayrepetitivity, linear range and uncertainty.
}


\author{
Maela Lupo, Alfredo Rigalli
}

% \keyword{methods}
% \keyword{misc}