% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneSamplePoisson.R
\name{OneSamplePoisson}
\alias{OneSamplePoisson}
\title{One sample Poisson model}
\usage{
OneSamplePoisson(
  prior,
  N = 100,
  m0,
  m1,
  d = 0,
  ps = 0.95,
  pf = 0.05,
  alternative = c("less", "greater"),
  seed = 202209,
  sim = 5000
)
}
\arguments{
\item{prior}{A list of length 3 containing the distributional information of the prior.
The first element is a number specifying the type of prior. Options are
\enumerate{
\item DIP ;
\item Gamma(a,b), where a = shape, b = rate}
The second and third elements of the list are the parameters a and b, respectively.}

\item{N}{The planned sample size.}

\item{m0}{The null event rate, which could be taken as the standard or current event rate.}

\item{m1}{The event rate of the new treatment.}

\item{d}{The target improvement (minimal clinically meaningful difference).}

\item{ps}{The efficacy boundary (upper boundary).}

\item{pf}{The futility boundary (lower boundary).}

\item{alternative}{less (lower values imply greater efficacy) or greater (larger
values imply greater efficacy).}

\item{seed}{The seed for simulations.}

\item{sim}{The number of simulations.}
}
\value{
A list of the arguments with method and computed elements
}
\description{
For a given planned sample size, the efficacy and futility boundaries,
return the power, the type I error, the expected sample size and its
standard deviation, the probability of reaching the efficacy and futility boundaries.
}
\examples{
# with traditional Bayesian prior Gamma(0.5,0.001)
OneSamplePoisson(list(2,0.5,0.001), N = 100, m0 = 0.5, m1 = 0.4, d = 0.05,
                 ps = 0.95, pf = 0.05, alternative = "less",
                 seed = 202210, sim = 10)
# with DIP
OneSamplePoisson(list(1,0,0), N = 100, m0 = 0.5, m1 = 0.4, d = 0.05,
                 ps = 0.95, pf = 0.05, alternative = "less",
                 seed = 202210, sim = 10)
}
