% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncr_comp.R
\name{ncr_comp}
\alias{ncr_comp}
\title{Create a spectrogram using data from the free software CRExplorer}
\usage{
ncr_comp(
  df1,
  df2,
  py1,
  py2,
  col_cr = "red",
  smoothing = TRUE,
  par_pch = 20,
  ...
)
}
\arguments{
\item{df1}{data frame 1 with reference publication year and number of cited references, e. g., as exported from the CRExplorer (File > Export > CSV (Graph)).}

\item{df2}{data frame 2 with reference publication year and number of cited references, e. g., as exported from the CRExplorer (File > Export > CSV (Graph)).}

\item{py1}{determines lowest reference publication year which should be shown in the graph.}

\item{py2}{determines highest reference publication year which should be shown in the graph.}

\item{col_cr}{character color name value to determine color of the line and points of the number of cited references (optional parameter). The default value is "red".}

\item{smoothing}{boolean variable (optional parameter) which determines if the lines of the spectrogram are smoothed or not.
(T: yes apply smoothing, F: no do not apply smoothing). The default value is T.}

\item{par_pch}{integer value to set the point type (optional parameter). The default value is 20.}

\item{...}{additional arguments to pass to the \link{plot}, \link{points}, and \link{lines} functions.}
}
\description{
Provide the contents of CSV files from the 'CRExplorer' in data frames, e.g. df1 and df2,
and the function call ncr_comp(df1, df2, py1, py2) creates a plot with both sets of NCR values.
Here, py1 and py2 are the lowest and highest publication year to be used in the plot.
The function ncr_comp takes some optional arguments to modify its behaviour, see arguments and details.
}
\details{
ncr_comp <- function(df1, df2, py1, py2, col_cr = "red", smoothing = TRUE, par_pch = 20, ...)
Only the arguments df1, df2, py1, and py2 are necessary. All other aruments are optional.
Please use the function \code{legend} to add a user-defined legend
The solid curve represents the data from df1 and the dotted curve represents the data from df2.

Literature:

- Thor, A., Bornmann, L., Marx, W., Haunschild, R., Leydesdorff, L., & Mutz, Ruediger (2017). Website of the free software 'CRExplorer', http://www.crexplorer.net
}
