% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{Germ_lines_df}
\alias{Germ_lines_df}
\title{Germline Sequence Information for Various Species}
\format{
A data frame with 7,285 observations and 8 variables:
\describe{
  \item{sequence}{Germline nucleotide sequence (factor)}
  \item{names}{Gene name(s) (character string)}
  \item{species}{Species code or name (character string)}
  \item{chain}{Chain type (factor)}
  \item{accession}{Accession number (factor)}
  \item{species_name_official}{Official species name (character string)}
  \item{source}{Source of the germline sequence (character string)}
  \item{strain}{Strain or line information (character string)}
}
}
\source{
Data taken from the VDJgermlines package version 0.1
}
\usage{
data(Germ_lines_df)
}
\description{
This dataset, Germ_lines_df, is a data frame containing germline sequence information
for multiple species. The dataset includes 7,285 observations and 8 variables,
covering the nucleotide sequence, gene names, species, chain type, accession number,
official species name, source, and strain. All values are preserved as in the original source,
with no modifications.
}
\details{
The dataset name has been kept as 'Germ_lines_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
BioWorldR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified.
}
