% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{Tsd_turtle}
\alias{Tsd_turtle}
\title{Turtle Temperature-Dependent Sex Determination Data}
\format{
A data frame with 2,738 observations and 48 variables:
\describe{
  \item{Species}{Species name (factor)}
  \item{Country}{Country of observation (factor)}
  \item{Area}{Specific area or locality (character string)}
  \item{Longitude}{Longitude of the location (numeric)}
  \item{Latitude}{Latitude of the location (numeric)}
  \item{Subspecies}{Subspecies information (character string)}
  \item{RMU.2010}{RMU code (2010 version) (factor)}
  \item{RMU.2023}{RMU code (2023 version) (factor)}
  \item{Incubation.temperature.set}{Incubation temperature set experimentally (numeric)}
  \item{Incubation.temperature.recorded}{Recorded incubation temperature (numeric)}
  \item{Incubation.temperature.corrected}{Corrected incubation temperature (numeric)}
  \item{Duplicated.data}{Indicator for duplicated data (logical)}
  \item{Duplicate}{Duplicate identifier (character string)}
  \item{Incubation.temperature.Constant}{Constant temperature indicator (logical)}
  \item{Incubation.temperature.Accuracy}{Accuracy of incubation temperature (numeric)}
  \item{Incubation.temperature.SD}{Standard deviation of incubation temperature (numeric)}
  \item{Incubation.temperature.Amplitude}{Amplitude of incubation temperature (numeric)}
  \item{2ndThird.Incubation.temperature.Amplitude}{Amplitude during 2nd/3rd incubation period (numeric)}
  \item{Correction.factor}{Correction factor applied (numeric)}
  \item{Egg.mass.mean}{Mean egg mass (numeric)}
  \item{Egg.mass.sd}{Standard deviation of egg mass (numeric)}
  \item{IP.min}{Minimum incubation period (numeric)}
  \item{IP.max}{Maximum incubation period (numeric)}
  \item{IP.mean}{Mean incubation period (numeric)}
  \item{IP.SD}{Standard deviation of incubation period (numeric)}
  \item{IP.SE}{Standard error of incubation period (numeric)}
  \item{Length.hatchlings.mean}{Mean length of hatchlings (numeric)}
  \item{Length.hatchlings.sd}{Standard deviation of hatchling length (numeric)}
  \item{SCL.hatchlings.mean}{Mean straight carapace length of hatchlings (numeric)}
  \item{SCL.hatchlings.sd}{Standard deviation of hatchling carapace length (numeric)}
  \item{Mass.hatchlings.mean}{Mean hatchling mass (numeric)}
  \item{Mass.hatchlings.sd}{Standard deviation of hatchling mass (numeric)}
  \item{Total}{Total eggs recorded (numeric)}
  \item{Hatched}{Number of hatched eggs (numeric)}
  \item{NotHatched}{Number of unhatched eggs (numeric)}
  \item{Undeveloped}{Number of undeveloped eggs (numeric)}
  \item{Unidentified}{Number of unidentified eggs (numeric)}
  \item{Intersexes}{Number of intersex hatchlings (numeric)}
  \item{Males}{Number of male hatchlings (numeric)}
  \item{Females}{Number of female hatchlings (numeric)}
  \item{Sexed}{Number of sexed hatchlings (numeric)}
  \item{Number.clutch}{Number of clutches observed (numeric)}
  \item{Clutch}{Clutch identifier (factor)}
  \item{Box}{Box or container identifier (character string)}
  \item{Reference}{Reference for the data (character string)}
  \item{Note}{Additional notes (character string)}
  \item{Digital_Identifier}{Digital identifier (character string)}
  \item{Version}{Dataset version (Date)}
}
}
\source{
Data taken from the embryogrowth package version 10.3
}
\usage{
data(Tsd_turtle)
}
\description{
This dataset, Tsd_turtle, is a data frame containing extensive information on temperature-dependent
sex determination (TSD) in reptiles. The dataset includes 2,738 observations and 48 variables,
covering species, location, incubation temperatures, egg and hatchling measurements, sex ratios,
clutch information, and references. All values are preserved as in the original source, with no modifications.
}
\details{
The dataset name has been kept as 'Tsd_turtle' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
BioWorldR package and assists users in identifying its specific characteristics.
The suffix 'df' is not used here because the dataset is identified by its function within BioWorldR.
The original content has not been modified.
}
