
CUC_plot<-function(Prob,yt){
Th<-seq(0,100,by=0.01)
Missing_events<-function(x){sum(yt[Prob*100<x],na.rm=T)/sum(yt)*100}
Saved_treat<-function(x){length(yt[Prob*100<x]&!is.na(yt[Prob*100<x]))/length(yt)*100}

plot(Th,sapply(Th,Saved_treat),type="l",xlab="Threshold probability point",ylab="Percentage",main='',
     col="blue",ylim=c(-5,100),xlim=c(0,100),tck=1,fg="lightgray",xaxp=c(0,100,20),yaxp=c(0,100,20))
lines(Th,sapply(Th,Saved_treat),type="l",lwd=1.5,xlab="Threshold point",ylab="Percentage",col="blue",lty=1)
lines(Th,sapply(Th,Missing_events),type="l",lwd=1.5,xlab="Probabilidad de corte",ylab="Percentage",col="orange",
      ylim=c(-5,100),xlim=c(0,100),tck=1,fg="lightgray",xaxp=c(0,100,20),yaxp=c(0,100,20),lty=2)
axis(1,at=seq(0,100,by=5))
axis(2,at=seq(0,100,by=5))
axis(4,at=seq(0,100,by=5))
#leg.txt <- c("Saved treatment","Missing event")
legend(x=70,y=10, c("Saved treatment","Missing event"),text.width = 20, cex=0.8,
       col = c("blue","orange"), lwd=c(1.5,1.5),merge=TRUE,
       text.col = "black", lty = c(1,2))
}
