\name{CUC_plot}
\alias{CUC_plot}

\title{
Plot the clinical utility of a biomarker
}
\description{
The clinical utility plot shows two magnitudes, the number of events missclassfied below a cut off point and the saved treatments. In the X axis we can see the different cut off points and in the Y axis the magnitudes above defined.
}
\usage{CUC_plot(Prob,yt)
}

\arguments{
  \item{Prob}{A vector with the event probability values provided by the biomarker
}
\item{yt}{A vector with the actual event values
}

}
\details{
Prob must be a numeric vector with values between 0 and 1 and yt  a numeric vector with dichotomic values 0/1
}
\value{
The function returns the clinical utility curve
}
\author{Maria Escorihuela, Luis Mariano Esteban, Gerardo Sanz, Angel Borque
}
\examples{
###We generate a marker to serve as an example and plot the CUC curve
Prob<-c(rnorm(1000,0.4,0.1),rnorm(1000,0.6,0.05))
yt<-rep(c(0,1),c(1000,1000))
CUC_plot(Prob,yt)
}
\keyword{misc}
\keyword{clinical utility}
