\name{CUC_table}
\alias{CUC_table}

\title{
Clinical utility tools to analyze a predictive model
}
\description{
Efficacy of a biomarker defined by the treatment saved below a cut-off point minus the missclasified events.
}
\usage{CUC_table(Th,Prob,yt)
}

\arguments{
  \item{Th}{The vector of cutoff points used to estimate efficacy at those points.
}
  \item{Prob}{A vector with the event probability values provided by the biomarker.
}
\item{yt}{A vector with the actual event values
}

}
\details{
Prob must be a numeric vector with values between 0 and 1, yt  a numeric vector with dichotomic values 0/1 and z a numeric value between 0 and 100
}
\value{
The returned object contains the following components:
\item{CUC_table}{A data frame with three columns, the threshold points, the rate of missing events and the rate of avoided treatments}
}
\author{Maria Escorihuela, Luis Mariano Esteban, Gerardo Sanz, Angel Borque
}
\examples{
###We generate a marker to serve as an example

Prob<-c(rnorm(1000,0.4,0.1),rnorm(1000,0.5,0.05))
yt<-rep(c(0,1),c(1000,1000))
#We choose a grid of threshold points.
Th<-seq(1,100)
#Estimte the Clinical utility table
CUC_table(Th, Prob, yt)
}
\keyword{misc}
\keyword{clinical utility}
