% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diphiseq.R
\name{outprop}
\alias{outprop}
\title{Give a rough estimate of the proportion of outliers in the data based on the results of DiPhiSeq.}
\usage{
outprop(diphiseq.res, fdr.cutoff = 0.1)
}
\arguments{
\item{diphiseq.res}{The results given by running diphiseq.}

\item{fdr.cutoff}{The cutoff for FDR.}
}
\value{
a numeric value. The estimated proportion of outliers under the FDR cutoff in the data.
}
\description{
Give a rough estimate of the proportion of outliers in the data based on the results of DiPhiSeq.
}
\examples{
countmat <- matrix(rnbinom(100, size=1, mu=50), nrow=4, ncol=25)
classlab <- c(rep(1, 10), rep(2, 15))
res <- diphiseq(countmat, classlab)
outlier.proportion <- outprop(res)
}
