% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsm_without_strata.R
\name{som}
\alias{som}
\title{Selection Order Matrix (SOM)}
\usage{
som(
  data_frame = NULL,
  n_treat,
  treat_sizes,
  include_discard = FALSE,
  method = "SCOMARS",
  control = FALSE,
  marginal_treat = NULL
)
}
\arguments{
\item{data_frame}{A (optional) data frame corresponding to the full sample of units. 
Required if \code{include_discard = TRUE}.}

\item{n_treat}{Number of treatment groups.}

\item{treat_sizes}{A vector of treatment group sizes. If \code{control = TRUE}, 
the first element of \code{treat_sizes} should be the control group size.}

\item{include_discard}{\code{TRUE} if a discard group is considered.}

\item{method}{Specifies the selection strategy used among \code{'global percentage'}, 
\code{'randomized chunk'}, \code{'SCOMARS'}. \code{'SCOMARS'} is applicable only if \code{n_treat = 2}.}

\item{control}{If \code{TRUE}, treatments are labeled as 0,1,...,g-1 (0 representing the control group). 
If \code{FALSE}, they are labeled as 1,2,...,g.}

\item{marginal_treat}{A vector of marginal probabilities, the jth element being the probability that treatment group
 (or treatment group 2 in case \code{control = FALSE}) gets to choose at the jth stage given
the total number of choices made by treatment group upto the (j-1)th stage. 
Only applicable when \code{method = 'SCOMARS'}.}
}
\value{
A data frame containing the selection order of treatments, i.e. the labels of treatment groups 
at each stage of selection. If \code{method = 'SCOMARS'}, the data frame contains an additional column of 
the conditional selection probabilities.
}
\description{
Generates a Selection Order Matrix (SOM) in a deterministic/random manner.
}
\examples{
# Generate an SOM with N = 12, n1 = n2 = 6.
som_sample = som(data_frame = NULL, n_treat = 2, treat_sizes = c(6,6), include_discard = FALSE, 
method = 'SCOMARS', control = FALSE, marginal_treat = rep(6/12,12))
}
\references{
Chattopadhyay, A., Morris, C. N., and Zubizarreta, J. R. (2020), 
``Randomized and Balanced Allocation of Units into Treatment Groups Using the Finite Selection Model for \code{R}''.

Morris, C. (1983), ``Sequentially controlled Markovian random sampling (SCOMARS)'', Institute of 
Mathematical Statistics Bulletin,12(5), 237.
}
\author{
Ambarish Chattopadhyay, Carl N. Morris and Jose R. Zubizarreta.
}
