% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotPos.R
\name{PlotPos}
\alias{PlotPos}
\title{Plotting Position Probability}
\usage{
PlotPos(data_obs, PP)
}
\arguments{
\item{data_obs}{A vector, data frame or matrix containing observed data or flood quantiles.}

\item{PP}{A character string that determines the empirical formula used to calculate the probability.
The formula can be chosen from the list: \code{"Blom"}, \code{"Chegodayev"}, \code{"California"}
\code{"Gringorten"}, \code{"Hazen"}, \code{"Tukey"}, and \code{"Weibull"}.}
}
\value{
The function returns the probabilities assigned to the observed data as a vector of numerics.
}
\description{
\code{PlotPos} returns the empirical probability values corresponding to 
   the observed data of hydrological extreme events as a vector of numerics.
}
\details{
This is a function to calculate the emprical probability values assigned to the observed data
   of hydrological extreme events to be plotted.
}
\section{Reference}{

Chow, V. T., Maidment, D. R., & Mays, L. W. (1988). \emph{Applied Hydrology}. McGraw-Hill, New York, U.S.
}

\examples{
# First Example
data('Harricana')
PlotPos(data_obs = Harricana, PP = 'Weibull')

# Second Example
data('B17C_Tab8_1')
PlotPos(data_obs = B17C_Tab8_1, PP = 'Cunnane')

}
\seealso{
\code{\link{ProbPlot}} for graphical frequency analysis.
}
