% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/HDGLM_test.r
\name{HDGLM_test}
\alias{HDGLM_test}
\title{Tests the Coefficients of High Dimensional Generalized Linear Models}
\usage{
HDGLM_test(Y, X, beta_0 = NULL, nuisance = NULL, model = "gaussian")
}
\arguments{
\item{Y}{a vector of observations of length \eqn{n},  where \eqn{n} is the sample size.}

\item{X}{a design matrix with \eqn{n} rows and \eqn{p} columns, where \eqn{p} is the dimension of the covariates.}

\item{beta_0}{a vector with length \eqn{p}. It is the value of regression coefficient under the null hypothesis in global test.  The default
is \eqn{\beta_0=0} and it can be non-zero in the global test. In the test with nuisance coefficients, we only deal with  \eqn{\beta_0^{(2)}=0}.}

\item{nuisance}{an index indicating which coefficients are nuisance parameter. The default is \code{"NULL"} (the global test).}

\item{model}{a character string to describe the model and link function. The default is \code{"gaussian"}, which denotes the linear model using identity link.
The other options are \code{"poisson"}, \code{"logistic"}  and \code{"negative_binomial"} models, where the poisson and negative binomial models using log link.}
}
\value{
An object of class "HDGLM_test" is a list containing the following components:
\item{test_stat}{the standardized test statistic}
\item{test_pvalue}{pvalue of the test against the null hypothesis}
}
\description{
Tests for whole or partial regression coefficient vectors for high dimensional generalized linear models.
}
\note{
In global test,  the function \code{"HDGLM_test"} can deal with the null hypothesis with non-zero coefficients (\eqn{\beta_0}). However, in test with nuisance coefficient,
the function can only deal with the null hypothesis with zero coefficients (\eqn{\beta_0^{(2)}}) in this version.
}
\examples{
## Example: Linear model
## Global test: if the null hypothesis is true (beta_0=0)
alpha=runif(5,min=0,max=1)
## Generate the data
DGP_0=DGP(80,320,alpha)
result=HDGLM_test(DGP_0$Y,DGP_0$X)
## Pvalue
result$test_pvalue

## Global test: if the alternative hypothesis is true
## (the square of the norm of the first 5 nonzero coefficients to be 0.2)
## Generate the data
DGP_0=DGP(80,320,alpha,sqrt(0.2),5)
result=HDGLM_test(DGP_0$Y,DGP_0$X)
## Pvalue
result$test_pvalue

## Test with nuisance coefficients: if the null hypothesis is true (beta_0^{(2)}=0)
## The first 10 coefficients to be the nuisance coefficients
betanui=runif(10,min=0,max=1)
## Generate the data
DGP_0=DGP(80,320,alpha,0,no=NA,betanui)
result=HDGLM_test(DGP_0$Y,DGP_0$X,nuisance=c(1:10))
## Pvalue
result$test_pvalue

## Test with nuisance coefficients: if the alternative hypothesis is true
## (the square of the norm of the first 5 nonzero coefficients in beta_0^{(2)} to be 2)
## The first 10 coefficients to be the nuisance coefficients
betanui=runif(10,min=0,max=1)
## Generate the data
DGP_0=DGP(80,330,alpha,sqrt(2),no=5,betanui)
result=HDGLM_test(DGP_0$Y,DGP_0$X,nuisance=c(1:10))
## Pvalue
result$test_pvalue
}
\author{
Bin Guo
}
\references{
Guo, B. and Chen, S. X. (2015). Tests for High Dimensional Generalized Linear Models.
}

