% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_brownlie1981.R
\name{n_brownlie1981}
\alias{n_brownlie1981}
\title{Compute form roughness via Brownlie (1981)}
\usage{
n_brownlie1981(depth, slope, d16, d50, d84, restrict = TRUE)
}
\arguments{
\item{depth}{flow depth (H) in meters (m). The original model was calibrated
for 0.025 m < H < 17 m.}

\item{slope}{channel slope (S) in (m/m). The original model was calibrated
for 3*10^-6 < S < 0.037.}

\item{d16}{grain size (d16) in millimeters.}

\item{d50}{grain size (d50) in millimeters. The original model was calibrated
for 0.088 mm < d50 < 2.8 mm.}

\item{d84}{grain size (d84) in millimeters.}

\item{restrict}{allows for function parameters to restrict certain values. Type bool. Default TRUE.}
}
\value{
Manning's n
}
\description{
\code{n_brownlie1981} calculate Manning's n using the Brownlie (1981) Method
for estimating form roughness.
}
\examples{
# Result: Manning's n of 0.022
n_brownlie1981(10,0.02,1,1.1,1.2)

# Result: Manning's n of 0.018
n_brownlie1981(2.5,0.01,0.1,0.2,0.5)

# Result: Manning's n of 0.045
n_brownlie1981(15,0.003,0.6,0.9,1)

# Result: Depth must be within 0.025 and 17 m.
n_brownlie1981(20,0.003,0.6,0.9,1)

}
\references{
Brownlie, W. R. 1981. Prediction of flow depth and sediment discharge in open
channels. Report No. KH-R-43A. W.M. Keck Laboratory of Hydraulics and
Water Resources. California Institute of Technology.
}
