% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{sigma4}
\alias{sigma4}
\title{Unbiased estimate of squared variance $sigma^4$ based on U-statistic of an i.i.d. sample}
\usage{
sigma4(x)
}
\arguments{
\item{x}{is a vector of i.i.d. observations.}
}
\value{
unbiased estimate of squared variance $sigma^4$, where $sigma^2$ is the variance.
}
\description{
This function takes a random sample and produces an unbiased estimate of the squared variance based on
the U-statistic $sum_{k1 ne k2 ne k3 ne k4} (x_{k1}-x_{k2)})^2 (x_{k3}-x_{k4)})^2$.
}
\examples{
  x=stats::rnorm(10)
  sigma4(x)
}
