% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stReg.R
\name{coefficients.stein}
\alias{coefficients.stein}
\alias{coef.stein}
\title{Extract Model Coefficients}
\usage{
\method{coefficients}{stein}(object, ...)

\method{coef}{stein}(object, ...)
}
\arguments{
\item{object}{An object of class \code{stein}.}

\item{...}{Other arguments.}
}
\value{
A vector of coefficients.
}
\description{
Coefficients extracted from the model object \code{stein}
}
\examples{
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
p <- ncol(X)
# H beta = h
H <- matrix(c(1, 1, -1, 0, 0, 1, 0, 1, 0, -1, 0, 0, 0, 1, 0), nr = 3, nc = p, byrow = TRUE)
h <- rep(0, nrow(H))
model <- stReg(X, y, H, h)
coefficients(model)
coef(model)
}
\seealso{
\code{\link{coefficients.unrestricted}},
\code{\link{coefficients.restricted}},
\code{\link{coefficients.preliminaryTest}},
\code{\link{coefficients.improvedpreliminaryTest}},
\code{\link{coefficients.positivestein}},
\code{\link{coef.unrestricted}},
\code{\link{coef.restricted}},
\code{\link{coef.preliminaryTest}},
\code{\link{coef.improvedpreliminaryTest}},
\code{\link{coef.positivestein}}.
}
