% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resReg.R
\name{fitted.restricted}
\alias{fitted.restricted}
\title{Extract Model Fitted Values}
\usage{
\method{fitted}{restricted}(object, ...)
}
\arguments{
\item{object}{An object of class \code{restricted}.}

\item{...}{Other arguments.}
}
\value{
Fitted values extracted from the object \code{restricted}.
}
\description{
Fitted values based on object \code{restrcited}.
}
\examples{
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
p <- ncol(X)
# H beta = h
H <- matrix(c(1, 1, -1, 0, 0, 1, 0, 1, 0, -1, 0, 0, 0, 1, 0), nrow = 3, ncol = p, byrow = TRUE)
h <- rep(0, nrow(H))
model <- resReg(X, y, H, h)
fitted(model)
}
\seealso{
\code{\link{fitted.unrestricted}},
\code{\link{fitted.preliminaryTest}},
\code{\link{fitted.improvedpreliminaryTest}},
\code{\link{fitted.stein}},
\code{\link{fitted.positivestein}}
}
