% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptReg.R
\name{ptReg}
\alias{ptReg}
\title{The Preliminary Test Estimator}
\usage{
ptReg(X, y, H, h, alpha, is_error_normal = FALSE)
}
\arguments{
\item{X}{Matrix with input observations, of dimension \code{n} x \code{p};
each row is an observation vector.}

\item{y}{Vector with response observations of size \code{n}.}

\item{H}{A given \code{q} x \code{p} matrix.}

\item{h}{A given \code{q} x \code{1} vector.}

\item{alpha}{A given significance level.}

\item{is_error_normal}{logical value indicating whether the errors follow
a normal distribution. If \code{is_error_normal} is \code{TRUE},
 the distribution of the test statistics for the null hypothesis
 is F distribution (\code{\link[stats]{FDist}}).
 On the other hand, if the errors have a non-normal distribution,
 the asymptotic distribution of the test statistics is \eqn{\chi^2}
 distribution (\code{\link[stats]{Chisquare}}).
 By default, \code{is_error_normal} is set to \code{FALSE}.}
}
\value{
An object of class \code{preliminaryTest} is a list containing at least the following components:
  \describe{
    \item{\code{coef}}{A named vector of coefficients.}
    \item{\code{residuals}}{The residuals, that is, the response values minus fitted values.}
    \item{\code{s2}}{The estimated variance.}
    \item{\code{fitted.values}}{The fitted values.}
  }
}
\description{
This function calculates the preliminary test. When the error has a normal
distribution, the test statistic is given by
\deqn{\hat{\beta}^{PT}=\hat{\beta}^{U} - (\hat{\beta}^{U} - \hat{\beta}^{R}) I(\mathcal{L} \le F_{q,n-p}(\alpha))}
and, if the error has a non-normal distribution, is given by
\deqn{\hat{\beta}^{PT}=\hat{\beta}^{U} - (\hat{\beta}^{U} - \hat{\beta}^{R}) I(\mathcal{L} \le \chi^2_{q}(\alpha))}
where \eqn{I(A)} denotes an indicator function and
\itemize{
  \item \eqn{\hat{\beta}^{U}} is the unrestricted estimator; See \code{\link{unrReg}}.
  \item \eqn{\hat{\beta}^{R}} is the restricted estimator; See \code{\link{resReg}}.
  \item \eqn{\mathcal{L}} is the test statistic. See \code{\link{teststat}};
  \item \eqn{F_{q,n-p}(\alpha)} is the upper \eqn{\alpha} level critical value of \eqn{F}-distribution with \eqn{(q,n-p)} degrees of freedom, calculated using \code{\link[stats]{qf}};
  \item \eqn{\chi^2_{q}(\alpha)}is the upper \eqn{\alpha} level critical value of \eqn{\chi^2}-distribution with \eqn{q} degree of freedom, calculated using \code{\link[stats]{qchisq}};
  \item \eqn{\alpha}: the significance level.
}
}
\details{
The corresponding estimator of \eqn{\sigma^2} is
\deqn{s^2 = \frac{1}{n-p}(y-X\hat{\beta}^{PT})^{\top}(y - X\hat{\beta}^{PT}).}
}
\examples{
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
p <- ncol(X)
# H beta = h
H <- matrix(c(1, 1, -1, 0, 0, 1, 0, 1, 0, -1, 0, 0, 0, 1, 0), nrow = 3, ncol = p, byrow = TRUE)
h <- rep(0, nrow(H))
ptReg(X, y, H, h, alpha = 0.05)

# H beta != h
p <- ncol(X)
H <- matrix(c(1, 1, -1, 0, 0, 1, 0, 1, 0, -1, 0, 0, 0, 1, 0), nrow = 3, ncol = p, byrow = TRUE)
h <- rep(1, nrow(H))
ptReg(X, y, H, h, alpha = 0.05)

data(cement)
X <- as.matrix(cbind(1, cement[, 1:4]))
y <- cement$y
# Based on Kaciranlar et al. (1999)
H <- matrix(c(0, 1, -1, 1, 0), nrow = 1, ncol = 5, byrow = TRUE)
h <- rep(0, nrow(H))
ptReg(X, y, H, h, alpha = 0.05)
# Based on Kibria (2005)
H <- matrix(c(0, 1, -1, 1, 0, 0, 0, 1, -1, -1, 0, 1, -1, 0, -1), nrow = 3, ncol = 5, byrow = TRUE)
h <- rep(0, nrow(H))
ptReg(X, y, H, h, alpha = 0.05)

}
\references{
Saleh, A. K. Md. Ehsanes. (2006). \emph{Theory of Preliminary Test and Stein‐Type Estimation With Applications}, Wiley.

Kaciranlar, S., Akdeniz, S. S. F., Styan, G. P. & Werner, H. J. (1999). A new biased
estimators in linear regression and detailed
analysis of the widely-analysed dataset on
portland cement. \emph{Sankhya, Series B}, 61(3), 443-459.

Kibria, B. M. Golam (2005). Applications of Some Improved Estimators in Linear Regression,
\emph{Journal of Modern Applied Statistical Methods}, 5(2), 367- 380.
}
