\name{DepqueueNHK}
\alias{DepqueueNHK}
\alias{DepqueueKenv}

\title{Estimating cross K-function  and envelopes for the marginal processes of a  queue}

\description{This function estimates the  cross K-function  between 
two (homogenous or nonhomogeneous)  point processes in time, \eqn{N_x} and \eqn{N_y}.  
It  is evaluated in a grid of distances \eqn{r} and plotted. An envelope built  by simulation under the  hypothesis
that the processes are the marginal processes (the input and the output) of a queue is also plotted.

It calls the auxiliary functions NHKaux, NHKaux2, NHKaux3 and DepqueueKenv, not intended for users.}

\usage{DepqueueNHK(posx, posy, lambda,  T=NULL, nserv='infty', ddist='exp',argd=1,r=NULL, 
	typeEst=1, nsim=1000, conf=0.95,tit=NULL, cores=1,fixed.seed=NULL,...)}

\arguments{

  \item{posx}{Numeric vector.  Occurrence times of the  points in the first point processes \eqn{N_x}.}

  \item{posy}{Numeric vector.  Occurrence times of the  points in the second point processes \eqn{N_y}.}

  \item{lambda}{Numeric vector. Intensity values of  the input process \eqn{N_x}.}

  \item{T}{Optional. Positive integer. Length of the period where the point are  going to be generated. 
	Only used in homogeneous processes (if lambda is a constant).}

  \item{nserv}{Optional.  Number of servers in the queue system; only two  values are possible: 1 or "infty" if the  number of servers is infinity.}

  \item{ddist}{Character string.  Identification of the probability distribution of the  serving time. It must be one of the  names of the probability distributions available in the stats package, 
	see \code{\link{Distributions}}; for example "gamma", "geom", etc.}. 

  \item{argd}{Optional. Numeric  value or vector  containing the arguments to be used in the probability distribution  in \code{ddist}.}

  \item{r}{Optional. Numeric vector.  Grid values where  the K-function  must be evaluated. If it  is NULL, a default vector is used; 
see Details.}

   \item{typeEst}{Optional. Two possible values: 1 or 2. They determine which one of the two  available estimators  
	of the function \eqn{K_{ij}} has to be used; see Details. }

  \item{nsim}{Optional. Numeric value.  Number of simulations  to obtain the envelope.}

  \item{conf}{Optional. Numeric value  in (0,1). Confidence level of the envelope for the K-function.}


  \item{tit}{Optional.  Title to be used in the plot of the K-function. }

  \item{cores}{Optional. Number of cores of the computer to be used in the calculations. }

  \item{fixed.seed}{An integer or NULL. If it is an integer, that is the value  used to set the seed 
in  random  generation processes. It it is NULL, a random seed is used.}

  \item{...}{Further arguments to  be passed to the function \code{\link{plot}}.}
}

\details{

This function estimates the cross K function  between two (homogenous or nonhomogeneous)  point processes 
in time, \eqn{N_x} and \eqn{N_y}. Two different estimators are available, see  \code{\link{NHK}} for  details.

An envelope for the cross K function is built  under the hypothesis that the  processes are the input and the 
output processes of a queue.  The envelope is based on simulations, where processes generated by
\code{\link{DepNHPPqueue}} are used. The distribution of the serving time is specified
in arguments \code{ddist} and  \code{argd}. The queue can have one or infinity servers.


If argument \code{r} is NULL,   the following r-grid is used to evaluate the function

		 r1<-max(20, floor(T/20))

		 r<-seq(1,r1,by=2)

		 if (length(r)>200) r<-seq(1,r1,length.out=200)

where \code{T} is the length of the observed period.
}

\value{ A list with elements:

 \item{r}{Vector of values \eqn{r} where the cross K-function is estimated.}
 \item{NHKr}{Estimated values of  \eqn{K_{ij}(r)}.}
 \item{KenvL}{Lower bounds of the envelope of\eqn{K_{ij}(r)}.}
 \item{KenvU}{Upper bounds of the envelope of \eqn{K_{ij}(r)}.}
 \item{T}{Length of the observed period of the processes.}

}

\seealso{\code{\link{NHK}}, \code{\link{DepNHPPqueue}} }


\examples{

#Observed process: independent Poisson processes
set.seed(123)
T<-1000
lambda1<-runif(T,0,0.05)
dendist<- dexp(c(1:T), 1)
lambda2<-convolve(lambda1,rev(dendist),type='o')[1:T]
posx<-simNHPc(lambda = lambda1, fixed.seed = 134)$posNH
posy<-simNHPc(lambda = lambda2, fixed.seed = 135)$posNH

DepqueueNHK(posx=posx, posy=posy, lambda=lambda1,  ddist='exp',argd=1, 
	r=seq(1,40, by=5), fixed.seed=123,nsim=500)

#Observed process: input and output processes  of a queue
#aux<-DepNHPPqueue(lambda=lambda1, d=2, fixed.seed=123, argd=1, dplot=FALSE)$posNH
#DepqueueNHK(posx=aux[[1]], posy=aux[[2]], lambda=lambda1,  ddist='exp',argd=1, 
#	r=seq(1,40, by=5), fixed.seed=123)

	

}
