% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LRMDE.R
\name{LRMDE}
\alias{LRMDE}
\title{Performs minimum distance estimation in linear regression model: Y=Xb + error}
\usage{
LRMDE(Y, X)
}
\arguments{
\item{Y}{- Response variable in linear regression model}

\item{X}{- Explanatory variable in linear regression model}
}
\value{
Returns betahat - Minimum distance estimator of b
}
\description{
Performs minimum distance estimation in linear regression model: Y=Xb + error
}
\examples{
X <- matrix(c(1,1,3,4, 4,2), nrow=3, ncol=2)
Y <- c(1,-5, 8)
bhat <- LRMDE(Y,X)
}
\references{
[1] Koul, H. L (1985). Minimum distance estimation in linear regression with unknown error distributions. Statist. Probab. Lett., 3 1-8.

[2] Koul, H. L (1986). Minimum distance estimation and goodness-of-fit tests in first-order autoregression. Ann. Statist., 14 1194-1213.

[3] Koul, H. L (2002). Weighted empirical process in nonlinear dynamic models. Springer, Berlin, Vol. 166
}
\seealso{
ARMDE
}

