% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.imcid.R
\name{cv.imcid}
\alias{cv.imcid}
\title{Selection of the tuning parameters for determining the MCID at the individual level}
\usage{
cv.imcid(x, y, z, lamseq, delseq, k = 5, maxit = 100, tol = 0.01)
}
\arguments{
\item{x}{a continuous variable denoting the outcome change of interest}

\item{y}{a binary variable denoting the patient-reported outcome derived from the anchor question}

\item{z}{a vector or matrix denoting the patient's clinical profiles}

\item{lamseq}{a vector containing the candidate values for the tuning parameter \eqn{\lambda}, where \eqn{\lambda} is the coefficient of the penalty term, used for avoiding the issue of model overfitting}

\item{delseq}{a vector containing the candidate values for the tuning parameter \eqn{\delta}, where \eqn{\delta} is used to control the difference between the 0-1 loss and the surrogate loss.
We recommend selecting the possible values from the neighborhood of the standard deviation of x}

\item{k}{the number of groups into which the data should be split to select the tuning parameter \eqn{\delta} by cross-validation. Defaults to 5}

\item{maxit}{the maximum number of iterations. Defaults to 100}

\item{tol}{the convergence tolerance. Defaults to 0.01}
}
\value{
a list including the combinations of the selected tuning parameters and the value of the corresponding target function
}
\description{
\code{cv.imcid} returns the optimal tuning parameter \eqn{\delta} and \eqn{\lambda} selected from a given grid by using k-fold cross-validation.
The tuning parameters are selected for determining the MCID at the individual level
}
\examples{
\donttest{
n <- 500
lambdaseq <- 10 ^ seq(-3, 3, 0.1)
deltaseq <- seq(0.1, 0.3, 0.1)
a <- 0.1
b <- 0.55
c <- -0.1
d <- 0.45

set.seed(721)
p <- 0.5
y <- 2 * rbinom(n, 1, p) - 1
z <- rnorm(n, 1, 0.1)
y_1 <- which(y == 1)
y_0 <- which(y == -1)
x <- c()
x[y_1] <- a + z[y_1] * b + rnorm(length(y_1), 0, 0.1)
x[y_0] <- c + z[y_0] * d + rnorm(length(y_0), 0, 0.1)

sel <- cv.imcid(x = x, y = y, z = z, lamseq = lambdaseq,
         delseq = deltaseq, k = 5, maxit = 100, tol = 1e-02)
sel$'Selected lambda'
sel$'Selected delta'
}

}
