% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SquareSpike.R
\name{SquareSpike}
\alias{SquareSpike}
\title{Generation of a Square-wave Signal}
\usage{
SquareSpike(baseline, peak, period, duty_cycle, trend, duration, resolution)
}
\arguments{
\item{baseline}{minimal oscillation value}

\item{peak}{maximal oscillation value}

\item{period}{oscillation period of the oscillating species (reciprocal of the frequency)}

\item{duty_cycle}{ratio of the active phase (oscillator above baseline) to the total oscillation period}

\item{trend}{percental decrease or increase in the peak value for the successive oscillation cycles; if set to 1, peak value remains unchanged}

\item{duration}{duration of the generated time course}

\item{resolution}{temporal resolution of the generated time course}
}
\value{
Returns a matrix with two columns: a time vector and an oscillator abundance vector.
}
\description{
This function takes in numeric arguments for a customizable, square-wave spike shape. A discretized time course is returned.
}
\details{
Standards:
\itemize{
 \item{\code{peak} must be larger than \code{baseline}}
 \item{\code{duration} must be larger than \code{resolution}}
 \item{\code{duration} must be a multiple of \code{resolution}}
 \item{\code{period} must be a multiple of \code{resolution}}
 \item{\code{duration}, \code{resolution}, \code{peak} and \code{period} must be larger than 0}
 \item{\code{baseline} must be larger or equal to 0}
 \item{\code{duty_cycle} must be larger than 0 and smaller or equal to 1}
 \item{\code{trend} must be larger than 0}
}
}
\examples{
# test effect of changes in period
m1 = SquareSpike(baseline = 200, peak = 1000, period = 50, duty_cycle = 0.6,
trend = 1, duration = 500, resolution = 0.1)
m2 = SquareSpike(baseline = 200, peak = 1000, period = 100, duty_cycle = 0.6,
trend = 1, duration = 500, resolution = 0.1)
m3 = SquareSpike(baseline = 200, peak = 1000, period = 200, duty_cycle = 0.6,
trend = 1, duration = 500, resolution = 0.1)

par(mfrow = c(3,1))
plot(m1, type = "l", xlab = "time", ylab = "abundance")
plot(m2, type = "l", xlab = "time", ylab = "abundance")
plot(m3, type = "l", xlab = "time", ylab = "abundance")

# test effect of changes in duty_cycle
m1 = SquareSpike(baseline = 200, peak = 1000, period = 100, duty_cycle = 0.3,
trend = 1, duration = 500, resolution = 0.1)
m2 = SquareSpike(baseline = 200, peak = 1000, period = 100, duty_cycle = 0.6,
trend = 1, duration = 500, resolution = 0.1)
m3 = SquareSpike(baseline = 200, peak = 1000, period = 100, duty_cycle = 0.9,
trend = 1, duration = 500, resolution = 0.1)

par(mfrow = c(3,1))
plot(m1, type = "l", xlab = "time", ylab = "abundance")
plot(m2, type = "l", xlab = "time", ylab = "abundance")
plot(m3, type = "l", xlab = "time", ylab = "abundance")

# test effect of changes in trend
m1 = SquareSpike(baseline = 200, peak = 1000, period = 100, duty_cycle = 0.6,
trend = 0.7, duration = 500, resolution = 0.1)
m2 = SquareSpike(baseline = 200, peak = 1000, period = 100, duty_cycle = 0.6,
trend = 1, duration = 500, resolution = 0.1)
m3 = SquareSpike(baseline = 200, peak = 1000, period = 100, duty_cycle = 0.6,
trend = 1.3, duration = 500, resolution = 0.1)

par(mfrow = c(3,1))
plot(m1, type = "l", xlab = "time", ylab = "abundance")
plot(m2, type = "l", xlab = "time", ylab = "abundance")
plot(m3, type = "l", xlab = "time", ylab = "abundance")
}
