% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_output_functions.R
\name{f_get_excel_template}
\alias{f_get_excel_template}
\title{Copy Excel Template for Model Parameters}
\usage{
f_get_excel_template(output_dir = NULL)
}
\arguments{
\item{output_dir}{Character string giving the directory to copy the template to.
If \code{NULL} (the default), the function uses: \code{tempdir()}. Change \code{tempdir()} into
\code{getwd()} for copying to working directory.}
}
\value{
A length-1 character string giving the absolute path to the copied
template file, returned invisibly.
}
\description{
Copy the bundled Excel template \code{PERSUADE_Excel_template.xltx} to a user-specified
directory. This template provides a convenient structure for transferring survival
model outputs from \pkg{PERSUADE} into health economic models.
}
\details{
The default Excel file \code{PERSUADE_Excel_template.xltx} is stored within
the package under \verb{inst/excel_template/}. This function locates the installed
file via \code{\link[=system.file]{system.file()}} and copies it into the requested directory. If a file
with the same name already exists at the destination, it will be overwritten.

The Excel template provides a standardized format for entering parametric
survival model parameters, making it easier to use PERSUADE outputs in
downstream decision-analytic models. Users may adapt the template as needed
for their specific workflows.
}
\examples{
\donttest{
# Copy output to temporary directory
# (change `tempdir()` into `getwd()` for
# copying to working directory)
f_get_excel_template(
output_dir = file.path(tempdir(), paste0("BC_OS", "_output"))
)
}

}
\seealso{
\code{\link[=f_generate_report]{f_generate_report()}}, \code{\link[=system.file]{system.file()}}
}
