% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_function.R
\name{f_tp}
\alias{f_tp}
\title{Calculate Transition Probabilities}
\usage{
f_tp(ngroups, cum_haz, time_unit)
}
\arguments{
\item{ngroups}{Integer. Number of groups (1-3).}

\item{cum_haz}{Data frame from \code{\link[=f_cum_hazard]{f_cum_hazard()}} with columns
\code{group}, \code{time}, \code{H_delta}, \code{H_upper_delta}, \code{H_lower_delta}.}

\item{time_unit}{Numeric. Time unit for annualization.}
}
\value{
A list with:
\itemize{
\item \code{gr_1}, \code{gr_2}, \code{gr_3}: Data frames of smoothed probabilities per group.
\item \code{max}: Maximum upper bound across all groups.
}
}
\description{
Derives annualized transition probabilities (and confidence bounds)
from cumulative hazard estimates, smoothed with LOESS.
}
\examples{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
cum_haz <- f_cum_hazard(
  years = years,
  status = status,
  group = group,
  ngroups = nlevels(group),
  time_pred = seq(0, 5000, 365.25),
  time_unit = 30
)
f_tp(ngroups = nlevels(group), cum_haz = cum_haz, time_unit = 30)

}
