% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plausibleAlts.R
\name{altFrequencyMat}
\alias{altFrequencyMat}
\title{Identify a region of plausible alternative hypotheses
in the proportion, strength of non-null evidence space}
\usage{
altFrequencyMat(logKappaRange, logW = FALSE)
}
\arguments{
\item{logKappaRange}{pair of numeric values}

\item{logW}{logical, should the log scale simulation be used?}
}
\value{
An 81 by 81 matrix giving summarized counts of cases.
}
\description{
This function provides a convenient way to interact
with simulations performed over a grid of possible alternatives
spanning the proportion (eta) and strength (KL divergence) of
evidence against the null hypothesis under beta alternatives.
}
\details{
The simulation this function summarized used a range of
eta, w, and KL divergence values to generate thousands of
potential alternative distributions. The power of each
chi-squared pooled p-value for 161 kappa values ranging from
exp(-8) to exp(8) selected uniformly on the log scale was then
computed for each alternative using 10,000 simulated examples.
Every choice of kappa was compared to the maximum power across
all kappas for each setting using a binomial test of differences.
This same simulation was repeated twice: once for w values
selected uniformly from 0 to 1 and another where selection was
uniform on the log scale. The internal data summarizes the results
by reporting the count of instances in w (or logw) where a given
kappa value was most powerful for a given eta and KL divergence.

Though the simulation data is not exported to users and so cannot
be accessed directly, this function allows a user to query the
data with a range of kappa values (corresponding to those where
a given sample seems most powerful) and returns the count of
cases in w where a kappa in the corresponding kappa range was most
powerful given the eta, KL-divergence combination with beta
alternatives. The simulations only spanned kappa values from
exp(-8) to exp(8), so providing values outside this range will
give very inaccurate results.
}
\examples{
altFrequencyMat(c(-1, 1), logW = FALSE)
altFrequencyMat(c(-1, 1), logW = TRUE)
}
\author{
Chris Salahub
}
