% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alternatives.R
\name{betaDiv}
\alias{betaDiv}
\title{Compute the Kullback-Leibler divergence between the beta
and uniform distributions}
\usage{
betaDiv(a, w = (1 - a)/(b - a), b = 1/w + a * (1 - 1/w))
}
\arguments{
\item{a}{first shape parameter between 0 and infinity}

\item{w}{UMP parameter between 0 and 1}

\item{b}{second shape parameter between 0 and infinity}
}
\value{
A real value.
}
\description{
Computes the Kullback-Leibler divergence for the
special case of the uniform density against the beta density.
}
\details{
This function accepts either the a/b parameterization
(equivalent to shape1/shape2 in R), or the a/w parameterization
which links the divergence to the UMP test.
}
\examples{
betaDiv(a = 0.5, w = 0.5)
betaDiv(a = 0.1, b = 1)
}
\author{
Chris Salahub
}
