% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.R
\name{estimateQ}
\alias{estimateQ}
\title{Compute the centrality quotient}
\usage{
estimateQ(
  poolFun,
  alpha = 0.05,
  M = 2,
  interval = c(0, 1),
  poolArgs = list(),
  ...
)
}
\arguments{
\item{poolFun}{function accepting a vector of p-values}

\item{alpha}{numeric between 0 and 1}

\item{M}{integer, how many p-values are there?}

\item{interval}{two numerics giving the bounds of root-searching}

\item{poolArgs}{(optional) additional named arguments for poolFun}

\item{...}{additional arguments to uniroot}
}
\value{
The uniroot output.
}
\description{
Estimates the centrality quotient for an arbitrary
pooled p-value function.
}
\details{
The centrality quotient communicates the tendency for a
test to favour evidence shared among all tests over strong
evidence in a single test.

This function uses the individual estimation functions for
central and marginal rejection levels to compute the centrality
quotient for an arbitrary pooled p-value function. The option to
specify b for marginal rejection is included in case the pooled p
-value has strange behaviour when p-values are equal to 1.
}
\examples{
estimateQ(chiPool, alpha = 0.05, M = 10, poolArgs = list(kappa = 10))
}
\author{
Chris Salahub
}
