% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcResamplingIUR.R
\name{calcResamplingIUR}
\alias{calcResamplingIUR}
\title{Calculate reliability using resampling inter-unit reliability method}
\usage{
calcResamplingIUR(
  df = NULL,
  model = NULL,
  entity = "entity",
  y = "y",
  ctrPerf = controlPerf(),
  ctrRel = controlRel()
)
}
\arguments{
\item{df}{observation-level data; if null, will use the dataframe from the model object}

\item{model}{model; if null, will use an unadjusted model}

\item{entity}{data column containing the accountable entity identifier}

\item{y}{data column containing the outcome variable}

\item{ctrPerf}{parameters to control performance measure calculation}

\item{ctrRel}{parameters to control reliability estimation}
}
\value{
A list containing:
\itemize{
\item \code{entity}: list of entities
\item \code{n}: entity sample sizes
\item \code{var.b}: between-entity variance
\item \code{var.w}: within-entity variance
\item \code{var.total}: total variance
\item \code{IUR}: entity-level reliability
}
}
\description{
This function estimates reliability using the resampling inter-unit reliability method described in He et al. 2018.
}
\details{
In the current version, this function assumes that the measure is a simple mean of outcome values
within each entity. However, this method is more flexible as described in He et al. 2018.
}
\examples{
# Simulate data
df <- simulateData(n.entity = 50, n.obs = 100, mu = .2, r = .7)

# Calculate reliability
out <- calcResamplingIUR(df = df, entity = 'entity', y = 'y', ctrRel = controlRel(n.resamples = 10))
out$IUR

}
\references{
He K, Kalbfleisch JD, Yang Y, Fei Z. Inter unit reliability for nonlinear models. Stat Med. 2019 Feb 28;38(5):844-854.
}
\author{
Kenneth Nieser (nieser@stanford.edu)
}
