% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createCutoffsDF.R
\name{createCutoffsDF}
\alias{createCutoffsDF}
\title{Create Cutoffs Dataframe}
\usage{
createCutoffsDF(X, z, gamma, type)
}
\arguments{
\item{X}{Numeric matrix of size \code{n} x \code{p}, where \code{n} is the
number is restaurants to be graded and \code{p} is the number of inspections
to be used in grade assignment.  Entry  \code{X[i,j]} represents the
inspection score for the \code{i}th restaurant in the \code{j}th most recent
inspection.}

\item{z}{Character vector of length \code{n} representing ZIP codes (or other
subunits within a jurisdiction).  \code{z[i]} is the ZIP code corresponding
to the restaurant with inspection scores in row \code{i} of \code{X}.}

\item{gamma}{Numeric vector representing absolute grade cutoffs or quantiles,
depending on \code{type} variable value. Entries in gamma should be
increasing, with \code{gamma[1] <= gamma[2]} etc (this is related to the
"Warning" section and larger scores being associated with higher risk). If
\code{type = "perc"} or \code{type = "perc.resolve.ties"}, gamma values
represent quantiles and should take on values between 0 and 1.}

\item{type}{Character string that is one of \code{"unadj"},
\code{"perc"}, or \code{"perc.resolve.ties"}, and that indicates the grading
algorithm to be implemented.}
}
\description{
\code{createCutoffsDF} is an internal function, which creates a dataframe with
identical cutoff values for all ZIP codes (if \code{type = "unadj"}), or
quantile cutoffs in a ZIP code (if \code{type = "perc"} or \code{type =
"perc.resolve.ties"}). This function is called extensively by the
\code{findCutoffs} function.
}
\details{
\code{createCutoffsDF} takes in a matrix of restaurants' scores and a vector
corresponding to restaurants' ZIP codes, and outputs a data frame of cutoff
scores to be used in grade classification. The returned ZIP code cutoff data
frame has one row for each unique ZIP code and has \code{(length(gamma)+1)}
columns, corresponding to one column for the ZIP code name, and
\code{(length(gamma))} cutoff scores separating the \code{(length(gamma)+1)}
grading categories.  Across each ZIP code's row, cutoff scores increase and we
assume, as in the King County (WA) case, that greater risk is associated with
larger inspection scores. (If scores are decreasing in risk, users should
transform inspection scores before utilizing functions in the
\code{QuantileGradeR} package with a simple function such as \code{f(score) =
- score}.)

The way in which cutoff scores are calculated for each ZIP code depends on the
value of the \code{type} variable.  The \code{type} variable can take one of
three values (see later).
}
\section{Modes}{
 \code{type = "unadj"} creates a ZIP code cutoff data frame
 with the same cutoff scores (meaningful values in a jurisdiction's
 inspection system that are contained in the vector \code{gamma}) for all ZIP
 codes. This ZIP code data frame can then be used to carry out "unadjusted"
 grading, in which a restaurant's most recent routine inspection score is
 compared to these cutoffs.

 \code{type = "perc"} takes in a vector of quantiles,
 \code{gamma}, and returns a data frame of the scores in each ZIP code
 corresponding to these quantiles (using the "Nearest Rank" definition of
 quantile).

 \code{type = "perc.resolve.ties"} takes in a vector of
 quantiles, \code{gamma}, and instead of returning (for B/C cutoffs, for
 example) the scores in each ZIP code that result in \emph{at least}
 (\code{gamma[2]} x 100)\% of restaurants in the ZIP code scoring less than
 or equal to these cutoffs, \code{type = "perc.resolve.ties"} takes into
 account the fact that ties exist in ZIP codes. Returned scores for A/B
 cutoffs are those that result in the \emph{closest} percentage of
 restaurants in the ZIP code scoring less than or equal to the A/B cutoff to
 the desired percentage, (\code{gamma[1]} x 100)\%. Similarly, B/C cutoffs
 are the scores in the ZIP code that result in the \emph{closest} percentage
 of restaurants in the ZIP code scoring less than or equal to the B/C cutoff
 and more than the A/B cutoff to the desired percentage, (\code{(gamma[2] -
 gamma[1])} x 100)\%.
}
\keyword{internal}

