% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gumbel.R
\name{gumbel}
\alias{gumbel}
\alias{dgumbel}
\alias{pgumbel}
\alias{qgumbel}
\alias{rgumbel}
\title{Gumbel distribution}
\usage{
dgumbel(x, location = 0, scale = 1, log = FALSE)

pgumbel(q, location = 0, scale = 1, lower.tail = TRUE, log.p = FALSE)

qgumbel(p, location = 0, scale = 1, lower.tail = TRUE, log.p = FALSE)

rgumbel(n, location = 0, scale = 1)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{location}{location parameter}

\item{scale}{scale parameter, must be positive.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{n}{number of random values to return}
}
\value{
\code{dgumbel} gives the density, \code{pgumbel} gives the distribution function, \code{qgumbel} gives the quantile function, and \code{rgumbel} generates random deviates.
}
\description{
Density, distribution function, quantile function, and random generation for
the Gumbel distribution.
}
\details{
This implementation of \code{dgumbel} allows for automatic differentiation with \code{RTMB}.
}
\examples{
x <- rgumbel(1, 0.5, 2)
d <- dgumbel(x, 0.5, 2)
p <- pgumbel(x, 0.5, 2)
q <- qgumbel(p, 0.5, 2)
}
