% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zinbinom.R
\name{zinbinom}
\alias{zinbinom}
\alias{dzinbinom}
\alias{pzinbinom}
\alias{rzinbinom}
\title{Zero-inflated negative binomial distribution}
\usage{
dzinbinom(x, size, prob, zeroprob = 0, log = FALSE)

pzinbinom(q, size, prob, zeroprob = 0, lower.tail = TRUE, log.p = FALSE)

rzinbinom(n, size, prob, zeroprob = 0)
}
\arguments{
\item{x, q}{vector of (non-negative integer) quantiles}

\item{size}{size parameter, must be positive.}

\item{prob}{mean parameter, must be positive.}

\item{zeroprob}{zero-inflation probability between 0 and 1.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return.}

\item{p}{vector of probabilities}
}
\value{
\code{dzinbinom} gives the density, \code{pzinbinom} gives the distribution function, and \code{rzinbinom} generates random deviates.
}
\description{
Probability mass function, distribution function, quantile function, and random generation for
the zero-inflated negative binomial distribution.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.
}
\examples{
set.seed(123)
x <- rzinbinom(1, size = 2, prob = 0.5, zeroprob = 0.5)
d <- dzinbinom(x, size = 2, prob = 0.5, zeroprob = 0.5)
p <- pzinbinom(x, size = 2, prob = 0.5, zeroprob = 0.5)
}
