% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riverbuilder.r
\name{riverbuilder}
\alias{riverbuilder}
\title{Generates graphs, text files, and coordinates related to a given set of river data.}
\source{
\url{http://pasternack.ucdavis.edu/research/projects/synthetic-river-valleys/}
}
\usage{
riverbuilder(filename, directory, overwrite)
}
\arguments{
\item{filename}{Name of the file to be processed.}

\item{directory}{Path in which outputs will be generated. If non-empty, it must contain "\\\\" or "/" between directories/files, and never "\\". An empty or invalid argument will result in files being generated in a temporary location.}

\item{overwrite}{Flag that determines whether existing files will be overwritten. If the files already exist and this value is FALSE, the program will stop and produce an error.}
}
\value{
None. Output files are generated in the specified (or temporary) directory: \cr \cr
BoundaryPoints.csv - Contains keys that map to specific points in CartesianCoordinates.csv that comprise the boundary around a river’s floodplain.\cr \cr
CartesianCoordinates.csv - Contains comma-separated XYZ coordinates for the synthetic river valley. A separate program such as ArcGIS can use these points to generate a 3D model.\cr \cr
Data.csv - Contains coefficients of variation, averages, standard deviations, channel slope, and other important information.\cr \cr
CenterlineCurvature.png - Displays the curvature of the channel's centerline.\cr \cr
CenterlineCurvature.csv - Contains coordinate data that was visualized in CenterlineCurvature.png.\cr \cr
ValleySection.png - Displays the cross section of the channel and floodplain at their midway point.\cr \cr
ValleySection.csv - Contains coordinate data that was visualized in ValleySection.png.\cr \cr
GCS.png - Displays the geometric covariance structures of: bankfull width and thalweg elevation; thalweg elevation and the channel meander.\cr \cr
GCS.csv - Contains coordinate data that was visualized in GCS.png.\cr \cr
LongitudinalProfile.png - Displays the side view of the river which consists of valley top, valley floor, bank top, and thalweg elevation.\cr \cr
LongitudinalProfile.csv - Contains coordinate data that was visualized in LongitudinalProfile.png.\cr \cr
Planform.png - Displays the bird’s eye view of the river which consists of the channel meander, channel bank, valley floor, and valley top.\cr \cr
Planform.csv - Contains coordinate data that was visualized in Planform.png.\cr \cr
}
\description{
Generates graphs, text files, and coordinates related to a given set of river data.
}
\examples{
file <- system.file("extdata", "Input.txt", package="RiverBuilder")
riverbuilder(file, '', TRUE)
}
