% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbs_diff.R
\name{sbs.chi}
\alias{sbs.chi}
\title{Satorra-Bentler Scaled Chi-Squared Difference Test (Based on Chi-Squared Values)}
\usage{
sbs.chi(chi0, chi1, df0, df1, c0, c1)
}
\arguments{
\item{chi0}{chi-squared value for the more restrictive model}

\item{chi1}{chi-squared value for the less restrictive model}

\item{df0}{degrees of freedom for the more restrictive model (with more degrees of freedom)}

\item{df1}{degrees of freedom for the less restrictive model (with fewer degrees of freedom)}

\item{c0}{scaling correction factor for the more restrictive model}

\item{c1}{scaling correction factor for the less restrictive model}
}
\value{
Change in model chi-squared, change in model degrees of freedom and the probability of rejecting the null
}
\description{
Takes chi-squared values from nested models estimated using maximum likelihood
with robust standard errors, model degrees of freedom, scaling correlation factors and returns:
(1) change in model chi-squared (2) change in model degrees of freedom and
(3) the probability of rejecting the null.
}
\examples{
chi0 <- 50

chi1 <- 40

df0 <- 10

df1 <- 9

c0 <- 1

c1 <- 1

sbs.chi(chi0,chi1,df0,df1,c0,c1)
}
