#' Chest-beating rates in gorillas
#'
#' Chest-beating rates in Gorillas.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 25 rows (one per gorilla) and 7 columns:
#' \describe{
#'   \item{Male}{An identifier}
#'   \item{NoChestBeats}{The number of chest beats}
#'   \item{FocalTime}{The focal time in hours 
#'         (i.e., time spent watching gorilla)}
#'   \item{ChestBeatRate}{The rate of chest beating, in beats per 10 hours}
#'   \item{BackBreadth}{The breadth of the gorilla's back, in cm}
#'   \item{Age}{Mean age during the study period, in years}
#'   \item{Age20}{Whether the gorillas is aged under 20 or not; 
#'         one of \code{Younger} or \code{Older}}
#' }
#' @source 
#' Wright, Edward, Sven Grawunder, Eric Ndayishimiye, Jordi Galbany, 
#' Shannon C.McFarlin, Tara S. Stoinski, and Martha M. Robbins. 2021. 
#' Chest Beats as an Honest Signal of Body Size in Male Mountain Gorillas 
#' (Gorilla Beringei Beringei). 
#' \emph{Scientific Reports} \bold{11} (1): 6879.
#' 
#' @usage 
#' data(Gorillas)
#' 
#' @examples
#' plot( ChestBeatRate ~ BackBreadth, 
#'       data = Gorillas, 
#'       xlab = "Back breadth (cm)", 
#'       ylab = "Cheast-beating rate (per 10 hrs)")
#' 

"Gorillas"
