% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stress.R
\docType{data}
\name{Stress}
\alias{Stress}
\title{Stress before surgery}
\format{
A data frame with 19 rows and 2 columns:
\describe{
  \item{BeforeHours}{beta-endorphin concentrations measured 12--14 hours before surgery, in fmol/ml}
  \item{BeforeMins}{beta-endorphin concentrations measured 10 minutes before surgery, in fmol/ml}
}
}
\source{
D. J. Hand, F. Daly, A. D. Lunn, K. J. McConway, and E. Ostrowski (1994) 
A Handbook of Small Data Sets, London: Chapman and Hall. Dataset 232.
}
\usage{
data(Stress)
}
\description{
Stress at two time-points before surgery.
}
\examples{
with(Stress, hist(BeforeMins - BeforeHours,
     xlab = "Stress increase: hours before compared to minutes before"))

}
\references{
The original source is given as Hoaglin, D. C., Mosteller, F. 
and Tukey. J. W. 1985.
\emph{Exploring data tables, trends and shapes}.
 New York: John Wiley & Sons.
}
\keyword{datasets}
