% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMD.R
\name{GMD}
\alias{GMD}
\title{Geometric Mean Diameter}
\usage{
GMD(Mass, Size)
}
\arguments{
\item{Mass}{Numerical vector containing the mass of each particle size class}

\item{Size}{Numerical vector containing the average of each particle size class}
}
\value{
Geometric Mean Diameter
}
\description{
The function computes the geometric mean  diameter of particle size distribution
}
\examples{
data <- data.frame(Mass = c(15.1,28.9,11.3,14.6,7.9,22.2),
                   Size = c(0.053,0.1765,0.4,1.25,3.375,4.75))
attach(data)
GMD(Mass = Mass, Size = Size)
}
\references{
Perfect E, Rasiah V, Kay BD. (1992). Fractal Dimension of soil aggregate size distributions calculated on number and mass. Soil Science Society of America Journals, 56: 1407.
}
