% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UBStats_Main_Visible_ALL_202508.R
\name{CI.mean}
\alias{CI.mean}
\title{Confidence intervals for the mean}
\usage{
CI.mean(
  x,
  sigma = NULL,
  conf.level = 0.95,
  digits = 2,
  force.digits = FALSE,
  use.scientific = FALSE,
  data,
  ...
)
}
\arguments{
\item{x}{An unquoted string identifying the \emph{numeric}
variable whose mean is of interest. \code{x} can be the
name of a vector in the workspace or the name of one of
the columns in the data frame specified in the \code{data} argument.}

\item{sigma}{An optional numeric value specifying the
population standard deviation. If \code{NULL} (default)
the population standard deviation is estimated using the
data.}

\item{conf.level}{Numeric value specifying the required
confidence level; default to 0.95.}

\item{digits}{Integer value specifying the number of
decimals used to round statistics; default to 2. If the chosen rounding formats some
non-zero values as zero, the number of decimals is increased
so that all values have at least one significant digit, unless the argument
\code{force.digits} is set to \code{TRUE}.}

\item{force.digits}{Logical value indicating whether reported values
should be forcedly rounded to the number of decimals specified in
\code{digits} even if non-zero values are
rounded to zero (default to \code{FALSE}).}

\item{use.scientific}{Logical value indicating whether numbers
in tables should be displayed using
scientific notation (\code{TRUE}); default to \code{FALSE}.}

\item{data}{An optional data frame containing \code{x}.
If not found in \code{data}, \code{x} is taken from the
environment from which \code{CI.mean()} is called.}

\item{...}{Additional arguments to be passed to low level functions.}
}
\value{
A table reporting the confidence interval for the
population mean. If the variance is unknown, the interval is
built using percentiles from
both the normal and the Student's t distribution.
}
\description{
\code{CI.mean()} builds confidence intervals for the mean of a population.
}
\examples{
data(MktDATA, package = "UBStats")

# CI for the mean with KNOWN variance; default options
CI.mean(AOV, sigma = 30, data = MktDATA)

# CI for the mean with UNKNOWN variance;  
# - change digits and confidence level 0.99
CI.mean(AOV, conf.level = 0.99, digits = 3, data = MktDATA)

# Arguments force.digits and use.scientific
#  A variable taking very small values
SmallX<-MktDATA$AOV/5000 
#  - Default: manages possible excess of rounding
CI.mean(SmallX)
#  - Forcing digits to the default values (2)
CI.mean(SmallX, force.digits = TRUE)
#  - Allow scientific notation
CI.mean(SmallX, use.scientific = TRUE)

# Output the table with the requested interval
out.ci_mean<-CI.mean(AOV, data = MktDATA)

}
\seealso{
\code{\link{TEST.mean}()} to test hypotheses on a population
mean.
}
\author{
Raffaella Piccarreta \email{raffaella.piccarreta@unibocconi.it}
}
