% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UBStats_Main_Visible_ALL_202508.R
\name{CI.prop}
\alias{CI.prop}
\title{Confidence intervals for the proportion}
\usage{
CI.prop(
  x,
  success = NULL,
  conf.level = 0.95,
  digits = 2,
  force.digits = FALSE,
  use.scientific = FALSE,
  data,
  ...
)
}
\arguments{
\item{x}{An unquoted string identifying the variable of interest.
\code{x} can be the name of a vector
or a factor in the workspace or the name of one of the columns in the
data frame specified in the \code{data} argument.}

\item{success}{If \code{x} is a factor, a character vector, or a numeric
non-binary vector, \code{success} must be used to indicate the category/value
corresponding to success. The argument can be omitted (\code{NULL},
default) if \code{x} is a binary numeric vector (takes values 0 or 1 only;
in this case success is assumed to be 1) or a logical vector (in these
cases success is assumed to be \code{TRUE}).}

\item{conf.level}{Numeric value specifying the required
confidence level; default to 0.95.}

\item{digits}{Integer value specifying the number of
decimals used to round statistics; default to 2. If the chosen rounding formats some
non-zero values as zero, the number of decimals is increased
so that all values have at least one significant digit, unless the argument
\code{force.digits} is set to \code{TRUE}.}

\item{force.digits}{Logical value indicating whether reported values
should be forcedly rounded to the number of decimals specified in
\code{digits} even if non-zero values are
rounded to zero (default to \code{FALSE}).}

\item{use.scientific}{Logical value indicating whether numbers
in tables should be displayed using
scientific notation (\code{TRUE}); default to \code{FALSE}.}

\item{data}{An optional data frame containing \code{x}.
If not found in \code{data}, \code{x} is taken from the environment
from which \code{CI.prop()} is called.}

\item{...}{Additional arguments to be passed to low level functions.}
}
\value{
A table reporting the confidence intervals for
the population proportion of successes.
}
\description{
\code{CI.prop()} builds confidence intervals for the proportion of
successes in a population.
}
\examples{
data(MktDATA, package = "UBStats")

# Success = one value of a character vector or factor
CI.prop(WouldSuggest, success = "Yes", data = MktDATA)

# - change confidence level and rounding
CI.prop(Education, success = "Post-Grad", 
        conf.level = 0.9, digits = 4, 
        data = MktDATA)

# Success = numeric value
CI.prop(Children, success = 2, data = MktDATA)

# Binary variable ('success' is 1 by default)
CI.prop(LastCampaign, digits = 3, data = MktDATA)

# Logical variable ('success' is TRUE by default)
CI.prop(RespCampaign, conf.level = 0.9, digits = 3, data = MktDATA)

# Success based on combined conditions
# - Build a (logical) vector indicating whether a condition is satisfied
IsTop <- MktDATA$CustClass == "Gold" | MktDATA$CustClass == "Platinum"
CI.prop(IsTop, conf.level = 0.9)
# - A very rare event
HighAOV <- MktDATA$AOV>150
CI.prop(HighAOV, conf.level = 0.9)

# Arguments force.digits, use.scientific
# - Default: manages possible excess of rounding
CI.prop(HighAOV)
# - Forcing digits to the default values (2)
CI.prop(HighAOV, force.digits = TRUE)
# - Allow scientific notation
CI.prop(HighAOV, use.scientific = TRUE)

# Output results
out_ci_prop<-CI.prop(HighAOV)

}
\seealso{
\code{\link{TEST.prop}()} to test hypotheses on the
proportion of successes in a population.
}
\author{
Raffaella Piccarreta \email{raffaella.piccarreta@unibocconi.it}
}
