% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coltools.R
\name{lab2col}
\alias{lab2col}
\title{Labels to Colors}
\usage{
lab2col(x, pal, ref = x, NAcol)
}
\arguments{
\item{x}{vector of labels (always transformed to character)}

\item{pal}{colors used to build the palette (defaults to colors set by theme)}

\item{ref}{reference for assigning colors (defaults to elements of \code{x})}

\item{NAcol}{color to be used for NA values (defaults to color set by theme)}
}
\value{
a vector of colors for each element in \code{x} or, when \code{x} is missing, a function.
}
\description{
Assigns colors to the provided vector of labels.
}
\details{
This function assigns colors to each unique level of label vector \code{x}.
Mainly used for consistently assigning colors to a unique set of labels,
especially when the order of original labels might change (see examples).

Color of NA values and values outside of specified reference can be set using
\code{NAcol} argument. Set this to NA to omit the display of such values.

\code{ref} parameter can be specified to select the order of color assignment:
first element from \code{ref} will be assigned the first color from \code{pal},
second element - second color, and so on.

The list of provided colors is expanded by first adding shades and then adding
tints. However if the number of groups exceeds the number of provided colors
by more than 3 times the colors will be repeated.

When \code{x} is not specified - a function that generates colors based on
\code{pal} and \code{ref} is returned.
}
\examples{
 # iris example
 pairs(iris[,1:4], col=lab2col(iris$Species))

 # iris example with one group missing from reference
 pairs(iris[,1:4], col=lab2col(iris$Species, ref=c("setosa", "versicolor")))

 # example of using a coloring function
 # "color" function below will consistently assign colors to values in "ref".
 color <- lab2col(ref=unique(chickwts$feed))
 par(mfrow=c(1,2))
 means <- tapply(chickwts$weight, chickwts$feed, mean)
 barplot(means, col=color(names(means)), las=2)
 means <- sample(means)
 barplot(means, col=color(names(means)), las=2)

}
\seealso{
\code{num2col}
}
\author{
Karolis Koncevičius
}
