% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcsvd.R
\name{is.ultrametric}
\alias{is.ultrametric}
\title{Ultrametric Distance Property}
\usage{
is.ultrametric(hcsvd.obj)
}
\arguments{
\item{hcsvd.obj}{An object of type hcsvd(...)}
}
\value{
Returns TRUE if the ultrametric property is fulfilled. Otherwise FALSE.
}
\description{
This function checks the ultrametric property of a distance matrix obtained by HC-SVD.
}
\examples{
\donttest{
#Load the correlation matrix Bechtoldt from the psych
#package (see ?Bechtoldt for more information).
if (requireNamespace("psych", quietly = TRUE)) {
  data("Bechtoldt", package = "psych")
}

#Compute HC-SVD (with average linkage).
hcsvd.obj <- hcsvd(Bechtoldt)

#Check the ultrametric property
is.ultrametric(hcsvd.obj)
}

}
\references{
\cite{Bauer, J.O. (202Xa). Divisive hierarchical clustering using block diagonal matrix approximations. Working paper.}
}
\seealso{
\code{\link{hcsvd}}
}
