% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countb.R
\name{countb}
\alias{countb}
\title{countb}
\usage{
countb(x)
}
\arguments{
\item{x}{A data frame with 7 columns: the 1st column should refer to the
focal subject's identification code (e.g., column named "id1" as in the
output of dtable function); the 2nd column should refer to the
identification code of the interaction partner (e.g., "id2"); the
3rd column (e.g., "sender_id1") should refer whether the focal subject was
the initiator (coded 1) or the target of the social interaction (coded 0);
the 4th column should refer to the type/code of social interaction
recorded; the 5th column (e.g., "no_occurrence") should refer whether no
social interactions were recorded (coded as 1; NA's otherwise); the 6th
column (e.g., "missing") should refer whether the focal subject was
unavailable for observation (coded as 1; NA's otherwise); the 7th columns
(e.g., "observer") should refer to the observer's identification code.}
}
\value{
countb returns a list with asymmetric matrices, one for each observer
  and type of social interaction recorded. Matrix cells provide counts on the
  number of times social interactions were initiated by the row subjects and
  directed to the column subjects.
}
\description{
countb takes a data frame with dyadic social interactions' data (akin to that
returned by dtable function) and returns a list of asymmetric data matrices-
one for each observer and type of social interaction. Each matrix cell
provides counts on the number of times a specific type of social interaction
was initiated by the row subject and directed to the column subject.
}
\examples{
## create list of asymmetric matrices (data2) from data object
## data object is obtained by converting raw focal observations' data in ex_field_data with
## dtable function
 b <- c("+","-")
 data <- dtable(ex_field_data, bset = b)
 data2 <- countb(data)
 data2
}
