% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getb.R
\name{getb}
\alias{getb}
\title{Calculate the b-measure}
\usage{
getb(Xb, Xc, oneI = FALSE, oneM = FALSE)
}
\arguments{
\item{Xb}{Three-way (\eqn{I \times J(J-1)/2 \times M}) array with 
\eqn{I} assessors, \eqn{J(J-1)/2} product comparisons, \eqn{M} CATA 
attributes, where values are counts of types \code{b} and \code{c} from the function 
\code{\link[cata]{barray}}.}

\item{Xc}{Array of same dimension as \code{Xb}, where values are counts of 
types \code{b} and \code{c} from the function \code{\link[cata]{barray}}.}

\item{oneI}{Indicates whether calculation is for one assessor (default: \code{FALSE}).}

\item{oneM}{Indicates whether calculation is for one attribute (default: \code{FALSE}).}
}
\value{
b-measure
}
\description{
Function to calculate the b-measure, which quantifies the sensory 
differentiation retained.
}
\examples{
bread.bc <- barray(bread$cata[1:8,,1:5])
getb(bread.bc[,,1,], bread.bc[,,2,])
}
\references{
Castura, J.C., Meyners, M., Varela, P., & Næs, T. (2022). 
Clustering consumers based on product discrimination in check-all-that-apply 
(CATA) data. \emph{Food Quality and Preference}, 104564. 
\doi{10.1016/j.foodqual.2022.104564}.
}
\author{
J.C. Castura
}
