% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_functions.R
\name{fit.cbass}
\alias{fit.cbass}
\title{Fit CBASS model using reversible jump MCMC}
\usage{
fit.cbass(
  X,
  y,
  max.int = 3,
  max.basis = 10 * ncol(X),
  tau2 = 10,
  nmcmc = 10000,
  nburn = round(nmcmc/2),
  nthin = 10,
  h1 = 4,
  h2 = 20 * (length(unique(y)) - 1)/nrow(X),
  p.int.prior = 1/(1:max.int),
  verbose = FALSE,
  print.interval = round(nmcmc/100),
  init1 = FALSE,
  ordinal = NULL,
  writeout = FALSE,
  writedir = tempdir(),
  mod = NULL,
  restart = FALSE
)
}
\arguments{
\item{X}{n by p matrix of inputs on unit invteral}

\item{y}{n-length factor factor of categories}

\item{max.int}{maximum number of interactions, default 3}

\item{max.basis}{maximum number of basis functions for each latent mean function, default ncol(X)*10}

\item{tau2}{prior variance of basis regression coefficients, default 10}

\item{nmcmc}{number of MCMC samples, default 1e4}

\item{nburn}{number of MCMC samples to burn, default nmcmc/2}

\item{nthin}{number of samples by which to thin, default 10}

\item{h1}{first parameter for Gamma hyperprior on tau2, default 4}

\item{h2}{second parameter for Gamma hyperprior on tau2, default 20(d-1)/n}

\item{p.int.prior}{prior for number of interactions, default 1/(1:max.int)}

\item{verbose}{should progress be printed out? default false}

\item{print.interval}{how often should progress be printed out? default every 1\%}

\item{init1}{should model be initialized with single interaction model? default FALSE}

\item{ordinal}{indicator of ordinal predictors (non-categorical), usually computed automatically}

\item{writeout}{should samples be written out to text file? default FALSE}

\item{writedir}{where should text files be written? default tempdir()}

\item{mod}{initial / previous model fit, default NULL}

\item{restart}{should initial input model be used for starting chain? default FALSE}
}
\value{
A list of CBASS model parameters. LIST THEM.
}
\description{
Fit CBASS model using reversible jump MCMC
}
\examples{
set.seed(1)
n <- 100;  d <- 3
X <- matrix(runif(n*2, 0, 1), ncol=2)
mu <- scale(X)
bound <- qnorm(1/d^(1/(d-1)))
mu <- cbind(bound, mu)
z <- mu
z[,-1] <- rnorm(length(mu[,-1]), mu[,-1], 1)
y <- apply(z, 1, which.max)
mod <- fit.cbass(X, y, max.int=1, max.basis=10, nmcmc=1e3, nburn=500, nthin=10)
pred.chain <- pred.cbass(mod, X)
mu.hat <- apply(pred.chain, 2:3, mean)
mean(abs(mu - mu.hat))
plot(c(mu), c(mu.hat))
}
