library(checkargs)
context("isIntegerOrNaOrNanOrInfScalar")

test_that("isIntegerOrNaOrNanOrInfScalar works for all arguments", {
  expect_identical(isIntegerOrNaOrNanOrInfScalar(NULL, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(TRUE, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(FALSE, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(NA, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(0, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(-1, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(-0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(1, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(NaN, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(-Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar("", stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar("X", stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(c(TRUE, FALSE), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(c(FALSE, TRUE), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(c(NA, NA), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(c(0, 0), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(c(-1, -2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(c(-0.1, -0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(c(0.1, 0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(c(1, 2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(c(NaN, NaN), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(c(-Inf, -Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(c(Inf, Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(c("", "X"), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(c("X", "Y"), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_error(isIntegerOrNaOrNanOrInfScalar(NULL, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isIntegerOrNaOrNanOrInfScalar(TRUE, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isIntegerOrNaOrNanOrInfScalar(FALSE, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_identical(isIntegerOrNaOrNanOrInfScalar(NA, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(0, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(-1, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_error(isIntegerOrNaOrNanOrInfScalar(-0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isIntegerOrNaOrNanOrInfScalar(0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_identical(isIntegerOrNaOrNanOrInfScalar(1, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(NaN, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(-Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isIntegerOrNaOrNanOrInfScalar(Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_error(isIntegerOrNaOrNanOrInfScalar("", stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isIntegerOrNaOrNanOrInfScalar("X", stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isIntegerOrNaOrNanOrInfScalar(c(TRUE, FALSE), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isIntegerOrNaOrNanOrInfScalar(c(FALSE, TRUE), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isIntegerOrNaOrNanOrInfScalar(c(NA, NA), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isIntegerOrNaOrNanOrInfScalar(c(0, 0), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isIntegerOrNaOrNanOrInfScalar(c(-1, -2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isIntegerOrNaOrNanOrInfScalar(c(-0.1, -0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isIntegerOrNaOrNanOrInfScalar(c(0.1, 0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isIntegerOrNaOrNanOrInfScalar(c(1, 2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isIntegerOrNaOrNanOrInfScalar(c(NaN, NaN), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isIntegerOrNaOrNanOrInfScalar(c(-Inf, -Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isIntegerOrNaOrNanOrInfScalar(c(Inf, Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isIntegerOrNaOrNanOrInfScalar(c("", "X"), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isIntegerOrNaOrNanOrInfScalar(c("X", "Y"), stopIfNot = TRUE, message = NULL, argumentName = NULL))
})
