library(checkargs)
context("isNumberOrNaOrNanOrInfVector")

test_that("isNumberOrNaOrNanOrInfVector works for all arguments", {
  expect_identical(isNumberOrNaOrNanOrInfVector(NULL, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNumberOrNaOrNanOrInfVector(TRUE, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNumberOrNaOrNanOrInfVector(FALSE, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNumberOrNaOrNanOrInfVector(NA, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(0, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(-1, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(-0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(1, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(NaN, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(-Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector("", stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNumberOrNaOrNanOrInfVector("X", stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(TRUE, FALSE), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(FALSE, TRUE), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(NA, NA), stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(0, 0), stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(-1, -2), stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(-0.1, -0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(0.1, 0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(1, 2), stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(NaN, NaN), stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(-Inf, -Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(Inf, Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c("", "X"), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c("X", "Y"), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_error(isNumberOrNaOrNanOrInfVector(NULL, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNumberOrNaOrNanOrInfVector(TRUE, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNumberOrNaOrNanOrInfVector(FALSE, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_identical(isNumberOrNaOrNanOrInfVector(NA, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(0, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(-1, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(-0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(1, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(NaN, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(-Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_error(isNumberOrNaOrNanOrInfVector("", stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNumberOrNaOrNanOrInfVector("X", stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNumberOrNaOrNanOrInfVector(c(TRUE, FALSE), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNumberOrNaOrNanOrInfVector(c(FALSE, TRUE), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_identical(isNumberOrNaOrNanOrInfVector(c(NA, NA), stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(0, 0), stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(-1, -2), stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(-0.1, -0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(0.1, 0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(1, 2), stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(NaN, NaN), stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(-Inf, -Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNumberOrNaOrNanOrInfVector(c(Inf, Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_error(isNumberOrNaOrNanOrInfVector(c("", "X"), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNumberOrNaOrNanOrInfVector(c("X", "Y"), stopIfNot = TRUE, message = NULL, argumentName = NULL))
})
