% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{ci_mean_t}
\alias{ci_mean_t}
\title{Mean CI from Data}
\usage{
ci_mean_t(.data, x, conf.level = 0.95, ...)
}
\arguments{
\item{.data}{Data frame.}

\item{x}{Column name (unquoted).}

\item{conf.level}{Confidence level. Default: 0.95.}

\item{...}{Additional parameters for \code{\link[DescTools:MeanCI]{DescTools::MeanCI()}}.
See that function's documentation.}
}
\value{
A data frame with columns:
\itemize{
\item (if present) grouping variable names;
\item \code{mean} (\verb{<dbl>}) -- mean estimate;
\item \code{lwr.ci}, \code{upr.ci} (\verb{<dbl>}) -- lower and upper CI bounds.
}
}
\description{
\code{ci_mean_t()} calculates the mean's confidence interval (CI)
using the \emph{classic} formula with Student's t coefficient for data
in data frame format. This enhanced version of \code{\link[DescTools:MeanCI]{DescTools::MeanCI()}}
responds to \code{\link[dplyr:group_by]{dplyr::group_by()}}, enabling subgroup calculations.
Result is a data frame.
}
\examples{
# Example with built-in dataset
data(npk, package = "datasets")
head(npk)

# Basic CI calculation for crop yield
ci_mean_t(npk, yield)
# Interpretation: We're 95\% confident the true mean yield
# falls between lwr.ci and upr.ci

# Using pipe operator (tidyverse style)
npk |> ci_mean_t(yield)

# Compare yields with nitrogen (N) treatment vs. without
npk |>
  dplyr::group_by(N) |>
  ci_mean_t(yield)
# Look at the CIs: Do they overlap? Non-overlapping CIs suggest
# a potential difference between groups

# More complex grouping: Three factors at once
npk |>
  dplyr::group_by(N, P, K) |>
  ci_mean_t(yield)

# Example with iris dataset: Petal length by species
data(iris, package = "datasets")
iris |>
  dplyr::group_by(Species) |>
  ci_mean_t(Petal.Length)
# Notice how the three species have clearly different intervals

# Example with mtcars: MPG by number of cylinders
data(mtcars, package = "datasets")
mtcars |>
  dplyr::group_by(cyl) |>
  ci_mean_t(mpg)

# 90\% confidence interval (less confident, narrower interval)
npk |> ci_mean_t(yield, conf.level = 0.90)

# 99\% confidence interval (more confident, wider interval)
npk |> ci_mean_t(yield, conf.level = 0.99)

}
