% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/clttools.R
\name{distr.simu.plot}
\alias{distr.simu.plot}
\title{Histogram and Q-Q plot of any given continuous distribution}
\usage{
distr.simu.plot(distr, n, times, prob = NULL, qqplot = FALSE, col = "black", type = NULL,
main = NULL, sub = NULL)
}
\arguments{
\item{distr}{vector, all possible outcomes, population distribution}

\item{n}{number of trials in one simulation}

\item{times}{number of simulations}

\item{prob}{probability assigned to each possible outcome}

\item{qqplot}{an argument to output Q-Q plot or not, can be TRUE or FALSE}

\item{col}{color of the plot}

\item{type}{type of plot}

\item{main}{an overall title for the plot}

\item{sub}{a sub title for the plot}
}
\value{
Plot of mean value and corresponding probabilities for all simulated outcomes.
}
\description{
Histogram and Q-Q plot of any given continuous distribution
}
\details{
The default probabilty equals to 1/n. All the assigned probabilites must between 0 and 1.
}
\examples{
distr.simu.plot(distr = c(1,0.2,3.4,5,6.6,1.1,5,4.7,2.33,3), n = 4, times = 1000, col = 'red')
}

