% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hopkins.R
\name{hopkins}
\alias{hopkins}
\title{Calculate Hopkins statistic.}
\usage{
hopkins(X, n = ceiling(nrow(X)/10))
}
\arguments{
\item{X}{Data (matrix or data.frame) to check clusterability.}

\item{n}{The number of rows to sample from X. The default is 1/10th the number of rows of X.}
}
\value{
The value returned is actually 1-Hopkins statistic.
}
\description{
Calculate Hopkins statistic of given data.
}
\details{
Note: Package \code{clustertend} is deprecated.
Use package \code{hopkins} instead.

Sample data must be preprocessed into dataframe or matrix form before
given as the value of parameter "data".
}
\examples{
set.seed(1)
hopkins(iris[,-5], n=15)

}
\references{
Lawson, R.G. and Jurs, P.C.(1990).
New index for clustering tendency and its application to chemical problems.
Journal of Chemical Information and Computer Sciences. 30(1):36-41.
}
\author{
Kevin Wright, Luo YiLan, Zeng RuTong.
}
